<?php
spl_autoload_register(function ($className) {
    // Define the path to the PhpSpreadsheet folder
    $prefix = 'PhpOffice\\PhpSpreadsheet\\';
    $baseDir = __DIR__ . '/PhpSpreadsheet/src/';



    // Check if the class name starts with PhpOffice\PhpSpreadsheet
    if (strpos($className, $prefix) === 0) {
        // Remove the namespace prefix
        $relativeClass = substr($className, strlen($prefix));

        // Replace the backslashes with directory separators
        $file = $baseDir . str_replace('\\', '/', $relativeClass) . '.php';

        // If the file exists, include it
        if (file_exists($file)) {
            require $file;
        }
    }
});
